#delimit ;
capture log close; 

**************************** ;
**************************** ; 
****************************   This program prices out home health claims using CY2019 payment parameters;
**************************** ;
**************************** ; 

******** Determines when the program started;
local starttime = "$S_TIME";

******** Housekeeping stuff;
clear all;
set matsize 2000;
 
******* Clears the screen;
forvalues x = 1/10 {;
	display _n,_n(400);
	};

*******Sets up the log for the output;
local a1 = substr(c(current_time),1,2);
local a2 = substr(c(current_time),4,2);
local a3 = substr(c(current_time),7,2);

local b     = c(current_date);
local date  = `a1';
local date1 = `a2';
local date2 = `a3';
local date3 = c(current_date);

capture log using "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Forsstrom\CY2024\Repricing (2025 Rule)\Logs\(2) Repricing Regrouped Claims - hhf23 (`b')`a1'_`a2'_`a3'.log", replace;



******** Local variables;
local year = 2023;                 * Set this to isolate which episodes you want to keep (based on from date);

local rural_adjA_2019   = 0.015;   * This is the CY2019 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2019   = 0.040;   * This is the CY2019 rural adjustment value for the "Low population density" counties;
local rural_adjC_2019   = 0.030;   * This is the CY2019 rural adjustment value for the "All Other" counties;

local rural_adjA_2020   = 0.005;   * This is the CY2020 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2020   = 0.030;   * This is the CY2020 rural adjustment value for the "Low population density" counties;
local rural_adjC_2020   = 0.020;   * This is the CY2020 rural adjustment value for the "All Other" counties;

local rural_adjA_2021   = 0.000;   * This is the CY2021 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2021   = 0.020;   * This is the CY2021 rural adjustment value for the "Low population density" counties;
local rural_adjC_2021   = 0.010;   * This is the CY2021 rural adjustment value for the "All Other" counties;

local rural_adjA_2022   = 0.000;   * This is the CY2022 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2022   = 0.010;   * This is the CY2022 rural adjustment value for the "Low population density" counties;
local rural_adjC_2022   = 0.000;   * This is the CY2022 rural adjustment value for the "All Other" counties;

local rural_adjA_2023   = 0.000;   * This is the CY2023 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2023   = 0.010;   * This is the CY2023 rural adjustment value for the "Low population density" counties;
local rural_adjC_2023   = 0.000;   * This is the CY2023 rural adjustment value for the "All Other" counties;

local base_2019         = 3154.27; * This is the CY2019 base payment rate;
*local base_2020         = 1864.03; * This is the CY2020 base payment rate (PDGM);
local base_2020         = 3220.79; * This is the CY2020 base payment rate (153);
local base_2021         = 3284.88; * This is the hypothetical CY2021 base payment rate (153) - we take the 2020 rate multiply by the CY2021 wage index BNF and the payment update 3220.79*.9999*1.020 ;
local base_2022         = 3376.69; * This is the hypothetical CY2022 base payment rate (153) - we take the hypothetical 2021 rate multiply by the CY2022 wage index BNF and the payment update 3284.88*1.0019*1.026 ;
local base_2023         = 3512.11; * This is the hypothetical CY2022 base payment rate (153) - we take the hypothetical 2022 rate multiply by the CY2023 wage index BNF and the payment update 3376.69*1.0001*1.04 ;


local outlier_fdl_2019  = 0.51;    * This is the CY2019 FDL;
*local outlier_fdl_2020  = 0.56;    * This is the CY2020 FDL (PDGM);
local outlier_fdl_2020 = 0.51;    * This is the CY2020 FDL (153);
local outlier_fdl_2021 = 0.51;    * This is the hypothetical CY2021 FDL (153);
local outlier_fdl_2022 = 0.51;    * This is the hypothetical CY2022 FDL (153);
local outlier_fdl_2023 = 0.51;    * This is the hypothetical CY2023 FDL (153);

local aid_2019          =  66.34;  * This is CY2019 LUPA rate for Aides;
local mss_2019          = 234.82;  * This is CY2019 LUPA rate for MSS;
local occ_2019          = 161.24;  * This is CY2019 LUPA rate for OCC; 
local phy_2019          = 160.14;  * This is CY2019 LUPA rate for PT; 
local skn_2019          = 146.50;  * This is CY2019 LUPA rate for SN;
local spc_2019          = 174.06;  * This is CY2019 LUPA rate for SLP;

local aid_2020          =  67.78;  * This is CY2020 LUPA rate for Aides;
local mss_2020          = 239.92;  * This is CY2020 LUPA rate for MSS;
local occ_2020          = 164.74;  * This is CY2020 LUPA rate for OCC; 
local phy_2020          = 163.61;  * This is CY2020 LUPA rate for PT; 
local skn_2020          = 149.68;  * This is CY2020 LUPA rate for SN;
local spc_2020          = 177.84;  * This is CY2020 LUPA rate for SLP;

local aid_2021          =  69.11;  * This is CY2021 LUPA rate for Aides;
local mss_2021          = 244.64;  * This is CY2021 LUPA rate for MSS;
local occ_2021          = 167.98;  * This is CY2021 LUPA rate for OCC; 
local phy_2021          = 166.83;  * This is CY2021 LUPA rate for PT; 
local skn_2021          = 152.63;  * This is CY2021 LUPA rate for SN;
local spc_2021          = 181.34;  * This is CY2021 LUPA rate for SLP;

local aid_2022          =  71.04;  * This is CY2022 LUPA rate for Aides;
local mss_2022          = 251.48;  * This is CY2022 LUPA rate for MSS;
local occ_2022          = 172.67;  * This is CY2022 LUPA rate for OCC; 
local phy_2022          = 171.49;  * This is CY2022 LUPA rate for PT; 
local skn_2022          = 156.90;  * This is CY2022 LUPA rate for SN;
local spc_2022          = 186.41;  * This is CY2022 LUPA rate for SLP;

local aid_2023          =  73.93;  * This is CY2022 LUPA rate for Aides;
local mss_2023          = 261.72;  * This is CY2022 LUPA rate for MSS;
local occ_2023          = 179.70;  * This is CY2022 LUPA rate for OCC; 
local phy_2023          = 178.47;  * This is CY2022 LUPA rate for PT; 
local skn_2023          = 163.29;  * This is CY2022 LUPA rate for SN;
local spc_2023          = 194.00;  * This is CY2022 LUPA rate for SLP;

local lupa_add_skn_2019 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2019  = 1.6700;  * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2019 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);

local lupa_add_skn_2020 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2020  = 1.6700;  * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2020 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);

local lupa_add_skn_2021 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2021  = 1.6700;  * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2021 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);

local lupa_add_skn_2022 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2022  = 1.6700;  * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2022 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);
local lupa_add_ot_2022  = 1.6700;  * This is the LUPA add-on factor for OT  (This may be constant from year to year - check);

local lupa_add_skn_2023 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2023  = 1.6700;  * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2023 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);
local lupa_add_ot_2023  = 1.6700;  * This is the LUPA add-on factor for OT  (This may be constant from year to year - check);

local wageadj_2019      = 0.7610;  * This is the CY2019 labor share adjustment;
local wageadj_2020      = 0.7610;  * This is the CY2020 labor share adjustment;
local wageadj_2021      = 0.7610;  * This is the CY2021 labor share adjustment;
local wageadj_2022      = 0.7610;  * This is the CY2022 labor share adjustment;
local wageadj_2023      = 0.7610;  * This is the CY2022 labor share adjustment;

local nrs_2019          =  54.20;  * This is the CY2019 NRS payment rate;
local nrs_2020          =  55.01;  * This is the CY2020 NRS payment rate;
local nrs_2021          =  56.11;  * This is the hypothetical CY2021 NRS payment rate - we took the 2020 rate and multiplied it by the payment rate update 55.01*1.020;
local nrs_2022          =  57.57;  * This is the hypothetical CY2022 NRS payment rate - we took the hypothetical 2021 rate and multiplied it by the payment rate update 56.11*1.026;
local nrs_2023          =  59.87;  * This is the hypothetical CY2023 NRS payment rate - we took the hypothetical 2022 rate and multiplied it by the payment rate update 57.57*1.04;

****** Values for CY2019 found here  https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf;
local aidmin_19 = 1.053333333;           * Standardized Per-minute Aide Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local mssmin_19 = 4.156;                 * Standardized Per-minute MSS  Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local occmin_19 = 3.423333333;           * Standardized Per-minute OT   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local phymin_19 = 3.436666667;           * Standardized Per-minute PT   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local sknmin_19 = 3.27;                  * Standardized Per-minute SN   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local spcmin_19 = 3.618666667;           * Standardized Per-minute SLP  Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);

****** Values for CY2019 found here  https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf;
local aidmin_20 = 1.076;                 * Standardized Per-minute Aide Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local mssmin_20 = 4.24666666666667;      * Standardized Per-minute MSS  Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local occmin_20 = 3.49733333333333;      * Standardized Per-minute OT   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local phymin_20 = 3.51066666666667;      * Standardized Per-minute PT   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local sknmin_20 = 3.34133333333333;      * Standardized Per-minute SN   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local spcmin_20 = 3.69733333333333;      * Standardized Per-minute SLP  Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);

****** Values for CY2021 found here  https://www.cms.gov/files/document/mm12017.pdf;
local aidmin_21 = 1.096984127;           * Standardized Per-minute Aide Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local mssmin_21 = 4.329911504;           * Standardized Per-minute MSS  Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local occmin_21 = 3.566454352;           * Standardized Per-minute OT   Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local phymin_21 = 3.580042918;           * Standardized Per-minute PT   Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local sknmin_21 = 3.406919643;           * Standardized Per-minute SN   Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local spcmin_21 = 3.77006237;            * Standardized Per-minute SLP  Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);

****** Values for CY2022 found here  https://www.cms.gov/files/document/r11099cp.pdf#page=6;
local aidmin_22 = 1.127619048;           * Standardized Per-minute Aide Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local mssmin_22 = 4.450973451;           * Standardized Per-minute MSS  Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local occmin_22 = 3.666029724;           * Standardized Per-minute OT   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local phymin_22 = 3.680042918;           * Standardized Per-minute PT   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local sknmin_22 = 3.502232143;           * Standardized Per-minute SN   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local spcmin_22 = 3.875467775;           * Standardized Per-minute SLP  Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);

****** Values for CY2022 found here  https://www.cms.gov/files/document/r11802CP.pdf;
local aidmin_23 = 1.173333333;           * Standardized Per-minute Aide Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local mssmin_23 = 4.632;           * Standardized Per-minute MSS  Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local occmin_23 = 3.815333333;           * Standardized Per-minute OT   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local phymin_23 = 3.83;           * Standardized Per-minute PT   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local sknmin_23 = 3.644666667;           * Standardized Per-minute SN   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local spcmin_23 = 4.033333333;           * Standardized Per-minute SLP  Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);


******** Location of SSS Day files;
local APU_prov_file_2019  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\Failed APU CY2019 QAO HHCAHPS_claims_addrural_20181109.xlsx";								
local APU_prov_file_2020  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHA_APU_FAILEDHHAS_CY2020_20190910.xlsx";		
local APU_prov_file_2021  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHA_APU_FAILEDHHAS_CY2021_20201215_postappeal.xlsx";						
local APU_prov_file_2022  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHA_APU_FAILEDHHAS_CY2022_20210909.xlsx";	
local APU_prov_file_2023  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\Failed_APU_CY2023_RERUN_20221128.xlsx";

local HHVBP_2018_file     = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHVBP_PY2_PAYMENT_ADJ_20181106.xlsx";								
local HHVBP_2019_file     = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHVBP_PY3_PAYMENT_ADJ_20191017.xlsx";
local HHVBP_2020_file     = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHVBP_PY4_PAYMENT_ADJ_20201112.xlsx";	************** Note, no HHVBP adjustments again until 2025;	
						
local rural_file          = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\CY 2019-CY 2022 Rural- Add-On Payment Designations.xls";								
local wageindex_2019_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\CY 2019 Final HH PPS wage index All Areas-no counties listed.csv";								
local wageindex_2020_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\CY2020 508_Compliant_Version_of_All areas - no counties listed.csv";	
local wageindex_2021_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\508_Compliant_Version_of_cy_2021_hh_pps_wage_index.csv";	
local wageindex_2022_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\All areas - no counties listed of CY_2022__Home_Health_Wage_Index_Final_11_22_21.csv";	
local wageindex_2023_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\CY 2023 Final HH PPS Wage Index.csv";

#delimit ;
****** Combines two java grouper files together;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\GROUPER\ahhmp_oas_hhf23_v8219_330_jvout.dta", replace;
tempfile ahhmp_oas;
save   "`ahhmp_oas'";

****** Merges in APU info;
if `year' == 2019 import excel "`APU_prov_file_`year''", sheet("Failed APU CY2019 QAO HHCAHPS_c") firstrow allstring clear;
if `year' == 2020 import excel "`APU_prov_file_`year''", sheet("Failed APU CY2020")               firstrow allstring clear;
if `year' == 2021 import excel "`APU_prov_file_`year''", sheet("Failed APU CY2021")               firstrow allstring clear;
if `year' == 2022 import excel "`APU_prov_file_`year''", sheet("Failed APU CY2022")               firstrow allstring clear;
if `year' == 2023 import excel "`APU_prov_file_`year''", sheet("Failed_APU")                      firstrow allstring clear;

keep   ccn;
rename ccn provider;

** Creates a flag for whether the provider is in the file;
gen apu = 1;
replace provider = "0" + provider if length(provider) == 5;

** Saves a temp file;
tempfile apu;
save   "`apu'";



****** Importing HHVBP info (2018 for claims in 2019, 2019 for claims in 2020);
import excel "`HHVBP_2018_file'", sheet("Sheet1") firstrow clear;
keep   ccn final_pay_adj;
rename ccn provider;
rename final_pay_adj final_pay_adj2018;

** Saves a temp file;
tempfile hhvbp_2018;
save   "`hhvbp_2018'";

****** Importing 2019 HHVBP info (for claims in 2020);
import excel "`HHVBP_2019_file'", sheet("Sheet1") firstrow clear;
keep   ccn final_pay_adj;
rename ccn provider;
rename final_pay_adj final_pay_adj2019;

** Saves a temp file;
tempfile hhvbp_2019;
save   "`hhvbp_2019'";

****** Importing 2020 HHVBP info (for claims in 2021);
import excel "`HHVBP_2020_file'", sheet("Sheet1") firstrow clear;
keep   ccn final_pay_adj;
rename ccn provider;
rename final_pay_adj final_pay_adj2020;

** Saves a temp file;
tempfile hhvbp_2020;
save   "`hhvbp_2020'";

****** Importing 2021 HHVBP info (for claims in 2022) - There was no HHVBP adjustment this year so everyone just gets a value equal to 1;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf22_FINAL_2022\ANFILES\hhf22_150_epioas_exclude.dta", replace;
keep   provider;
duplicates drop;
gen final_pay_adj2021 = 1;

** Saves a temp file;
tempfile hhvbp_2021;
save   "`hhvbp_2021'";

****** Importing 2022 HHVBP info (for claims in 2023) - There was no HHVBP adjustment this year so everyone just gets a value equal to 1;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\ANFILES\hhf23_150_epioas_exclude.dta", replace;
keep   provider;
duplicates drop;
gen final_pay_adj2022 = 1;

** Saves a temp file;
tempfile hhvbp_2022;
save   "`hhvbp_2022'";


************** Imports information on rural counties from 2019 final rule;
import excel "`rural_file'", sheet("Rural counties") firstrow clear;

*** Creates rural categories;
gen     rural_cat = "";
replace rural_cat = "A" if category == "High Utilization";
replace rural_cat = "B" if category == "Low Population Density";
replace rural_cat = "C" if category == "All Other";

*** Variable housekeeping;
destring fips_cnty, replace;
drop name;

****** There are a few counties that are listed multiple times (with multiple names but the same category) - this deletes those and makes sure fips_cnty cant be used as an identifier;
duplicates drop;
isid fips_cnty;

****** Saves a temp file;
tempfile rural;
save   "`rural'";




******** This is the wage index from the final rule';
import delimited "`wageindex_`year'_file'", encoding(ISO-8859-2) clear ;
tempfile wage_index;
save   "`wage_index'";



******** Capped minutes info - loads up capped minutes, imports info on claim idea and payment, and creates an extra claim id variable that will be useful in merging to the HIPPS file;
use          "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf20_FINAL_2020\1_PRE_GROUPER\hhf20_150_epioas_exclude.dta", replace; 
append using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf21_FINAL_2021\hhf21_150_epioas_exclude";
append using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf22_FINAL_2022\ANFILES\hhf22_150_epioas_exclude.dta";
append using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\ANFILES\hhf23_150_epioas_exclude.dta";
keep abt_link clm_id pmt_amt aidcmin_cap msscmin_cap tot_occ_cmin_cap tot_phy_cmin_cap tot_skn_cmin_cap tot_spc_cmin_cap;
*keep if _merge == 3;
*drop    _merge;
gen double clm_id_2nd = clm_id;
compress;
tempfile cap_min;
save   "`cap_min'";



********* Loads up Stata file that has the simulated 60-day episodes that have been run through the java grouper.  This is before they were actually run through the grouper, so no hipps code yet;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\Sim60DayEps_hhf23_imputation_22 Jul 2024133546.dta", replace;

merge 1:1 abt_link using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\Sim60DayEps_hhf23_imputation_22 Jul 2024133546_predrop.dta", keepusing(days days_cat);

keep if _merge==3 ;

drop _merge; 

drop if days>=366 & days!=.;

********* Total visits (these are the combined visits after the two 30-day periods have been combined) and creates LUPA flag for the old payment system;
egen tot_cvis = rowtotal(aidcvis msscvis tot_skn_cvis  tot_phy_cvis tot_occ_cvis tot_spc_cvis);
gen lupa = tot_cvis <= 4;
replace pep = 0 if lupa == 1;
tab lupa;

rename lupa_add_1st_vis_revonly first_vis;

********* Merging Java output (this has HIPPS code) and drops episodes with no HIPPS code;
merge 1:1 abt_link using  "`ahhmp_oas'" , keepusing(*java*);
keep if _merge == 3;
drop    _merge;
drop if javahipps == "";


********** HIPPS Code Check;
gen ther_cvis = THER_CVIS;
gen     test1 = "";
replace test1 = "1" if (substr(javahipps,1,1) == "1" |substr(javahipps,1,1) == "2") & ther_cvis <= 13;
replace test1 = "2" if (substr(javahipps,1,1) == "1" |substr(javahipps,1,1) == "2") & ther_cvis >= 14 & ther_cvis <= 19;
replace test1 = "3" if (substr(javahipps,1,1) == "3" |substr(javahipps,1,1) == "4") & ther_cvis <= 13;
replace test1 = "4" if (substr(javahipps,1,1) == "3" |substr(javahipps,1,1) == "4") & ther_cvis >= 14 & ther_cvis <= 19;
replace test1 = "5" if                                                                ther_cvis >= 20;

gen     test2 = "";
replace test2 = "K" if (substr(javahipps,1,1) == "1" | substr(javahipps,1,1) == "3") & ther_cvis >= 0 & ther_cvis <= 5;
replace test2 = "L" if (substr(javahipps,1,1) == "1" | substr(javahipps,1,1) == "3") & ther_cvis >= 6 & ther_cvis <= 6;
replace test2 = "M" if (substr(javahipps,1,1) == "1" | substr(javahipps,1,1) == "3") & ther_cvis >= 7 & ther_cvis <= 9;
replace test2 = "N" if (substr(javahipps,1,1) == "1" | substr(javahipps,1,1) == "3") & ther_cvis >= 10 & ther_cvis <= 10;
replace test2 = "P" if (substr(javahipps,1,1) == "1" | substr(javahipps,1,1) == "3") & ther_cvis >= 11 & ther_cvis <= 13;

replace test2 = "K" if (substr(javahipps,1,1) == "2" | substr(javahipps,1,1) == "4") & ther_cvis >= 14 & ther_cvis <= 15;
replace test2 = "L" if (substr(javahipps,1,1) == "2" | substr(javahipps,1,1) == "4") & ther_cvis >= 16 & ther_cvis <= 17;
replace test2 = "M" if (substr(javahipps,1,1) == "2" | substr(javahipps,1,1) == "4") & ther_cvis >= 18 & ther_cvis <= 19;

replace test2 = "K" if (substr(javahipps,1,1) == "5" | substr(javahipps,1,1) == "5") & ther_cvis >= 20;

#delimit ;
gen new_hipps = test1 + substr(javahipps,2,1) + substr(javahipps,3,1) + test2 + substr(javahipps,5,1);



*********************** MAKE SURE ALL THESE NUMBERS EQUAL EACH OTHER!!!!!!!!!!!!!!!!;
count;
count if new_hipps == javahipps;
count if M0110_RECALC == javaepi_timing;
count if ASMTYPE == javaasmt_rsn;
drop ther_cvis new_hipps;

********* Creates a hipps variable (first 4 digit - so no info on NRS in this value) and shows some summary statistics;
gen      hipps = substr(javahipps,1,4);
codebook hipps;

********* NRS Weight Creation;
gen nrs_level = substr(javahipps,5,1);
gen     nrs_wgt_fnl = .;
replace nrs_wgt_fnl =  0.2698 if nrs_level == "S" | nrs_level == "1";
replace nrs_wgt_fnl =  0.9742 if nrs_level == "T" | nrs_level == "2";
replace nrs_wgt_fnl =  2.6712 if nrs_level == "U" | nrs_level == "3";
replace nrs_wgt_fnl =  3.9686 if nrs_level == "V" | nrs_level == "4";
replace nrs_wgt_fnl =  6.1198 if nrs_level == "W" | nrs_level == "5";
replace nrs_wgt_fnl = 10.5254 if nrs_level == "X" | nrs_level == "6";
tab nrs_wgt;
tab nrs_level;


********** Merges on needed variables from the 150 file;
********* !!!!!!!!!!!!!!! CHANGE THIS EVERY TIME !!!!!!!!!!!!!!!!!;
merge 1:1 abt_link using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\ANFILES\hhf23_150_epioas_exclude.dta", keepusing(val_85 lupa_add_1st_vis_revonly lupa_add clm_id) ;
keep if _merge == 3;
drop    _merge;
rename clm_id clm_id_org;

********** After I created the initial file that was fed into the grouper, I realized I didn't include some variables I needed (basically the variables indicating the claim ids of both the 30-day periods
********** that comprise the 60-day episode) - so I went back and made that file again.  In the future this can be cleaned up so I'm only loading up the SIM60DayEps.... file once;
********* !!!!!!!!!!!!!!! CHANGE THIS EVERY TIME !!!!!!!!!!!!!!!!!;
merge 1:1 abt_link  using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\Sim60DayEps_hhf23_22 Jul 2024105755_clm_id.dta";
keep if _merge == 3;
drop    _merge;
count;
count if clm_id == clm_id_org;
count if clm_id == clm_id_oth;
count if clm_id_2nd == .;
drop clm_id_org clm_id_oth;


******** Merges on the case-mix weights for each HIPPS (153 group version);
merge m:1 hipps using "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HIPPS Case-Mix Weight Crosswalk (2020)-60day.dta";
keep if _merge == 1 | _merge == 3;
drop    _merge;
tempfile weights;
save   "`weights'";


**** Creates variables for payday (length of episode used for PEPs) - the combined length of some 60 day episodes exceeds 60 days (because I look at the from date of the first claim and through date of the last claim) - in those
**** cases I censor at 60 days;
gen     payday1 = thru_dt - from_dt+1;
count;
count if payday1 > 60 & payday1 ~= .;
replace payday1 = 60 if payday1 >= 60 & payday1 ~= .;


****** Merges on capped minutes - capped minutes are for each 30 day claim.  Each 60 day episode has up to 2 thirty day claims.  That is why I merge twice and then sum together the capped minutes.  I also 
****** do the same with the claim payment on the thirty day claims;;
count;
merge m:1 clm_id using "`cap_min'";
keep if _merge == 3;
drop    _merge;

local list "aidcmin_cap msscmin_cap tot_occ_cmin_cap tot_phy_cmin_cap tot_skn_cmin_cap tot_spc_cmin_cap pmt_amt";
foreach x of local list {;
	rename `x' `x'_1;
	};

merge m:1 clm_id_2nd using "`cap_min'";
keep if _merge == 1 | _merge == 3;
drop    _merge;

local list "aidcmin_cap msscmin_cap tot_occ_cmin_cap tot_phy_cmin_cap tot_skn_cmin_cap tot_spc_cmin_cap pmt_amt";
foreach x of local list {;
	rename `x' `x'_2;
	egen `x' = rowtotal(`x'_1 `x'_2);
	drop `x'_1 `x'_2;
	};


******  This uses the capped minutes to set payment - renames the variables so it fits into the pricing code that was previously created;
rename tot_skn_cmin_cap tot_skn_cmin; 
rename tot_occ_cmin_cap tot_occ_cmin;
rename tot_phy_cmin_cap tot_phy_cmin;
rename tot_spc_cmin_cap tot_spc_cmin;
rename aidcmin_cap      aidcmin;
rename msscmin_cap      msscmin;



********* Merges on wage index info;
rename ben_cbsa ben_cbsa_serv ;
destring ben_cbsa_serv, replace;
merge m:1 ben_cbsa_serv using "`wage_index'";
keep if _merge == 1 | _merge == 3;
drop    _merge;



********* Merges on info for the rural add-on;
rename srvc_fipstcnty fips_cnty;
destring fips_cnty, replace;
merge m:1 fips_cnty using "`rural'";
keep if _merge == 1 | _merge == 3;
drop    _merge;

***** Not every episode merges to a rural category - this sets the variable to none if a episode doesn't merge;
replace rural_cat = "None" if rural_cat == "";

********* Sets up the rural add-on variable (what the rural add-on percentage amount is);		
gen     rural_add_on = 0;
replace rural_add_on = `rural_adjA_`year'' if rural_cat=="A";   *High utilization;
replace rural_add_on = `rural_adjB_`year'' if rural_cat=="B";   *Low population density;
replace rural_add_on = `rural_adjC_`year'' if rural_cat=="C";   *All Other; 



********* Merges on HHVBP adjustment;
merge m:1 provider using "`hhvbp_2018'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

merge m:1 provider using "`hhvbp_2019'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

merge m:1 provider using "`hhvbp_2020'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

merge m:1 provider using "`hhvbp_2021'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

merge m:1 provider using "`hhvbp_2022'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

destring final_pay*, replace;
replace final_pay_adj2018 = 1 if final_pay_adj2018 == .;
replace final_pay_adj2019 = 1 if final_pay_adj2019 == .;
replace final_pay_adj2020 = 1 if final_pay_adj2020 == .;
replace final_pay_adj2021 = 1 if final_pay_adj2021 == .;
replace final_pay_adj2022 = 1 if final_pay_adj2022 == .;



****** Merges on APU flag;
merge m:1 provider using "`apu'";
keep if _merge ==1 | _merge == 3;
drop    _merge;




********** Saves an intermediate file so I do not have to keep running the first part of the code if I want to troubleshoot something later on;
compress;
save "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\hh_output_sim153.dta", replace;
*/;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\hh_output_sim153.dta", replace;

********* Sets up a new local variable so that I use the correct version of variables before;	
if `year' == 2023 local yearshort = 23;
if `year' == 2022 local yearshort = 22;
if `year' == 2021 local yearshort = 21;
if `year' == 2020 local yearshort = 20;
if `year' == 2019 local yearshort = 19;


************************ All the code below should be very similar to T.J.'s pricing progams;

***** Base payment Rate;
gen base = `base_`year''*(1+rural_add_on);

***** Outlier FDL (with and without quality bonus);
gen fdl = base*`outlier_fdl_`year''*((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''));

***** LUPA rates (With and without quality bonus);
gen aidamt = `aid_`year''*(1+rural_add_on);
gen mssamt = `mss_`year''*(1+rural_add_on);
gen occamt = `occ_`year''*(1+rural_add_on);
gen phyamt = `phy_`year''*(1+rural_add_on);
gen sknamt = `skn_`year''*(1+rural_add_on);
gen spcamt = `spc_`year''*(1+rural_add_on);

***** Drops episodes if certain observations are missing;
drop  if wgt                       == .      ;	
drop  if wage_index`yearshort'     == .      ;


*****  Sets adjusted base payment for normal episodes (With quality and no-quality bonus);
gen     basepay = 0;
replace basepay = wgt*((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*base if pep == 0 & lupa == 0;

*****  Sets adjusted base payment for PEP episodes (With quality and no-quality bonus);
replace payday1 = lvisit-fvisit+1;
replace basepay = (((payday1)/60)*wgt)*((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*base if pep == 1 & lupa == 0;

	
	
***** Sets payment rates for LUPA episodes based on the per-visit rates (With quality and no-quality bonus);	
*** Removes the first visit from the total visit count if the episode satisfies the criteria for a LUPA add-on;		
replace tot_skn_cvis = tot_skn_cvis - 1 if first_vis == "SKN" & lupa == 1 & lupa_add == 1;
replace tot_phy_cvis = tot_phy_cvis - 1 if first_vis == "PT"  & lupa == 1 & lupa_add == 1;
replace tot_spc_cvis = tot_spc_cvis - 1 if first_vis == "SLP" & lupa == 1 & lupa_add == 1;
replace tot_occ_cvis = tot_occ_cvis - 1 if first_vis == "OT"  & lupa == 1 & lupa_add == 1;

*** Computes the per-visit cost for the LUPA payment (not including the LUPA add-on visit);
gen     pervisitcost = 0;
replace pervisitcost = ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*(aidcvis*aidamt + msscvis*mssamt       + tot_occ_cvis*occamt       + tot_phy_cvis*phyamt       + tot_skn_cvis*sknamt       + tot_spc_cvis*spcamt);

*** Add's on the adjusted per-visit cost for the LUPA payment if the LUPA add-on criteria is satisfier;
replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*sknamt*`lupa_add_skn_`year'' if first_vis == "SKN" & pep == 0 & lupa == 1 & lupa_add == 1;
replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*phyamt*`lupa_add_pt_`year''  if first_vis == "PT"  & pep == 0 & lupa == 1 & lupa_add == 1;
replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*spcamt*`lupa_add_slp_`year'' if first_vis == "SLP" & pep == 0 & lupa == 1 & lupa_add == 1;
replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*occamt*`lupa_add_ot_`year''  if first_vis == "OT"  & pep == 0 & lupa == 1 & lupa_add == 1;

*** Add's back on the first visit from the total visit count if it had been subtracted earlier;
replace tot_skn_cvis = tot_skn_cvis + 1 if first_vis == "SKN" & lupa == 1 & lupa_add == 1;
replace tot_phy_cvis = tot_phy_cvis + 1 if first_vis == "PT"  & lupa == 1 & lupa_add == 1;
replace tot_spc_cvis = tot_spc_cvis + 1 if first_vis == "SLP" & lupa == 1 & lupa_add == 1;
replace tot_occ_cvis = tot_occ_cvis + 1 if first_vis == "OT"  & lupa == 1 & lupa_add == 1;
	

****** Sets NRS payment (With quality and no-quality bonus);
gen     nrspay = 0;
gen nrs_wgt = nrs_wgt_fnl;
replace nrspay = nrs_wgt*`nrs_`year''*(1+rural_add_on)   if lupa == 0;
replace nrspay = nrspay*(payday1)/60                     if  pep == 1;


****** Sets Outlier Threshold;
gen out_thresh = basepay + fdl + nrspay;


display "`yearshort'";
display "`aidmin_23'";
****** Calculated the imputed cost;
gen outcost = (wage_index`yearshort'*`wageadj_`year''+ 1 - `wageadj_`year'')*(1+rural_add_on)*(aidcmin*`aidmin_`yearshort'' + msscmin*`mssmin_`yearshort'' + tot_occ_cmin*`occmin_`yearshort'' + tot_phy_cmin*`phymin_`yearshort'' + tot_skn_cmin*`sknmin_`yearshort'' + tot_spc_cmin*`spcmin_`yearshort'');

******  If per visit amount is greater than Outlier Threshold, apply the outlier payment;
gen     outpay = 0;
replace outpay = 0.8*(outcost - out_thresh) if outcost >= out_thresh & lupa ~= 1;

****** Adds base payment to NRS payment and outlier payment;
egen    totpay_nooutlier = rowtotal(basepay nrspay);
gen     pervisitcost_lupa = pervisitcost if lupa == 1;
replace pervisitcost_lupa = 0            if pervisitcost_lupa == 1;


****** Outlier cap;
**** Total non-outlier payments for each observation;
egen non_out = rowtotal(totpay_nooutlier pervisitcost_lupa);
**** For each observation, Create a variable for the HHA total of non-outlier payments;
by provider, sort: egen non_out_hha = total(non_out);
**** For each observation, Create a variable for the HHA total of outlier payments;
by provider, sort: egen     out_hha = total(outpay);
**** For each observation, determine the HHA specific outlier threshold;
replace non_out_hha = non_out_hha*1/9;
		
display "Number of outlier 30-day periods";
count if outpay > 0 & outpay ~= . ;
display "Number of outlier 30-day periods from a HHA over the 10% cap";
count if out_hha > non_out_hha  & outpay > 0 & outpay ~= .;
	
**** For each observation, keep the outlier payments as is or multiply the outlier payments by the ratio of the HHA specific outlier threshold divided by the HHA outlier payments;
replace outpay = min(outpay*1, outpay*(non_out_hha/out_hha));
**** Drops unneeded variables;
drop non_out non_out_hha out_hha;

*********************** I need to determine what to do with this - I'm thinking of commenting it out for the repricing - but I'm not sure what is most appropriate;
*	gen outold1=(basepay_19_old+nrspay_19)*(1/9);
*	replace outpay_19_old=min(outpay_19_old,outold1) if outcost_19_old >= out_thresh_19_old ;

egen tot_pmt_noadj = rowtotal(totpay_nooutlier outpay pervisitcost_lupa);


/*
********** Checks payments (Applies sequestration and HHCVB adjustment);
gen     tot_pmt = 0;
replace tot_pmt = round((totpay_nooutlier + outpay)*0.98*final_pay_adj2019,.01) if             month(thru_dt) < 5;
replace tot_pmt = round(pervisitcost*0.98*final_pay_adj2019,.01)                if lupa == 1 & month(thru_dt) < 5;

replace tot_pmt = round((totpay_nooutlier + outpay)*final_pay_adj2019,.01)      if             month(thru_dt) >= 5;
replace tot_pmt = round(pervisitcost*final_pay_adj2019,.01)                     if lupa == 1 & month(thru_dt) >= 5;
*/;

********** Checks payments (DOES NOT apply sequestration and HHCVB adjustment);
gen     tot_pmt = 0;
replace tot_pmt = round((totpay_nooutlier + outpay),.01)             ;
replace tot_pmt = round(pervisitcost,.01)                if lupa == 1;



***** Some summary statistics from the simulated 60-day episodes;
tab      hipps, sort;
tab      hipps;

gen hipps1 = substr(javahipps,1,1);
gen hipps2 = substr(javahipps,2,1);
gen hipps3 = substr(javahipps,3,1);
gen hipps4 = substr(javahipps,4,1);
gen hipps5 = substr(javahipps,5,1);

tab hipps1;
tab hipps2;
tab hipps3;
tab hipps4;
tab hipps5;
tab lupa;
tab pep;

gen outlier = outpay > 0 & outpay ~= .;
tab outlier;
summ wgt if lupa == 0 & pep == 0;

egen ther_cvis = rowtotal(tot_phy_cvis tot_occ_cvis tot_spc_cvis);
summ tot_cvis;
summ ther_cvis;

gen     vis_group = "";
replace vis_group = "1)  0-4"   if tot_cvis >= 0  & tot_cvis <=  4;
replace vis_group = "2)  5-13"  if tot_cvis >= 5  & tot_cvis <= 13;
replace vis_group = "3)  14-19" if tot_cvis >= 14 & tot_cvis <= 19;
replace vis_group = "4)  20-29" if tot_cvis >= 20 & tot_cvis <= 29;
replace vis_group = "5)  30+"   if tot_cvis >= 30 & tot_cvis ~=  .;
tab     vis_group;

summ aidcvis msscvis tot_skn_cvis tot_phy_cvis tot_occ_cvis tot_spc_cvis;

gen any_therapy = ther_cvis >= 1 & ther_cvis ~= .;
tab any_therapy;

summ aidcmin msscmin tot_skn_cmin tot_phy_cmin tot_occ_cmin tot_spc_cmin;
summ aidcmin msscmin tot_skn_cmin tot_phy_cmin tot_occ_cmin tot_spc_cmin if outlier == 1;

summ outpay  if outlier == 1, detail;
display "Total: `r(sum)'";
summ tot_pmt if lupa    == 1;
display "Total: `r(sum)'";
summ tot_pmt if pep     == 1 & outlier == 0;
display "Total: `r(sum)'";
summ tot_pmt if pep     == 1 & outlier == 1;
display "Total: `r(sum)'";
summ tot_pmt if pep     == 0 & outlier == 1;
display "Total: `r(sum)'";
summ tot_pmt if outlier == 0 & lupa == 0 & pep == 0;
display "Total: `r(sum)'";

***** Claim payment for 30 day periods;
summ pmt_amt, detail;
return list;

**** Simulated total payment for 60-day episode (non-outlier payments) - no adjustments;
summ totpay_nooutlier, detail;
return list;

**** Simulated total payment for 60-day episode (outlier payments)- no adjustments;
summ outpay, detail;
return list;

**** Simulated total payment for 60-day episode (lupa payments) - no adjustments;
summ pervisitcost_lupa, detail;
return list;

**** Simulated total payment for 60-day episode - no adjustments;
summ tot_pmt_noadj, detail;
return list;

**** Simulated total payment for 60-day episode - no adjustments THERAPY;
summ tot_pmt_noadj if (tot_phy_cvis > 0 | tot_occ_cvis > 0 | tot_spc_cvis > 0), detail;
return list;

**** Simulated total payment for 60-day episode - no adjustments NO THERAPY;
summ tot_pmt_noadj if tot_phy_cvis == 0 & tot_occ_cvis == 0 & tot_spc_cvis == 0, detail;
return list;

**** Simulated payment for 60-day episode - with adjustments;
summ tot_pmt, detail;
return list;

****** Saves files indicating which istherapy and which is no therapy;
preserve;
keep if (tot_phy_cvis > 0 | tot_occ_cvis > 0 | tot_spc_cvis > 0);
compress;
save "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\hh_output_sim153(therapy).dta", replace;
restore;

preserve;
keep if tot_phy_cvis == 0 & tot_occ_cvis == 0 & tot_spc_cvis == 0;
compress;
save "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\hh_output_sim153(notherapy).dta", replace;
restore;


#delimit ;							
******** Creates summaries of unadjusted payment amounts;							
summ outpay if outlier == 1;							
local a1 = `r(N)';							
local a2 = `r(mean)';							
local a3 = `r(sum)';							
							
summ tot_pmt_noadj          if outlier == 0 & pep == 0 & lupa == 1;							
local b1 = `r(N)';							
local b2 = `r(mean)';							
local b3 = `r(sum)';							
							
summ tot_pmt_noadj          if outlier == 0 & pep == 1 & lupa == 0;							
local c1 = `r(N)';							
local c2 = `r(mean)';							
local c3 = `r(sum)';							
							
summ tot_pmt_noadj          if outlier == 1 & pep == 1 & lupa == 0;							
local d1 = `r(N)';							
local d2 = `r(mean)';							
local d3 = `r(sum)';							
							
summ tot_pmt_noadj          if outlier == 1 & pep == 0 & lupa == 0;							
local e1 = `r(N)';							
local e2 = `r(mean)';							
local e3 = `r(sum)';							
							
summ tot_pmt_noadj          if outlier == 0 & pep == 0 & lupa == 0;							
local f1 = `r(N)';							
local f2 = `r(mean)';							
local f3 = `r(sum)';							
							
summ tot_pmt_noadj;							
local g1 = `r(N)';							
local g2 = `r(mean)';							
local g3 = `r(sum)';							
							
summ wgt if lupa == 0;							
local h1 = `r(N)';							
local h2 = `r(mean)';	

summ tot_pmt_noadj          if outlier == 0 & pep == 0 & lupa == 0 & tot_phy_cvis == 0 & tot_occ_cvis == 0 & tot_spc_cvis == 0;							
local i1 = `r(N)';							
local i2 = `r(mean)';							
local i3 = `r(sum)';						

summ tot_pmt_noadj          if outlier == 0 & pep == 0 & lupa == 0 & (tot_phy_cvis > 0 | tot_occ_cvis > 0 | tot_spc_cvis > 0);							
local j1 = `r(N)';							
local j2 = `r(mean)';							
local j3 = `r(sum)';						

							
forvalues times = 1/1 {;					
	display "Unadjusted payments";						
	display "            Outlier Payments:    `a1'		`a2'		`a3'";		
	display "            LUPA    Payments:    `b1'		`b2'		`b3'";		
	display "   PEP (No outlier) Payments:    `c1'		`c2'		`c3'";		
	display "      PEP + Outlier Payments:    `d1'		`d2'		`d3'";		
	display "   Outlier (No PEP) Payments:    `e1'		`e2'		`e3'";		
	display "             Normal Payments:    `f1'		`f2'		`f3'";		
	display "                All Payments:    `g1'		`g2'		`g3'";		
	display "    Avg Weight for non-LUPAs:    `h1'      `h2'            ";						
	display "Normal Payments (No therapy):    `i1'		`i2'		`i3'";	
	display "   Normal Payments (Therapy):    `j1'		`j2'		`j3'";	
};

display "This is what Mollie requested - HIPPS with info on visits - drops LUPAs - simulated 60-day episodes";
preserve;
drop if lupa == 1;
gen eps = 1;
collapse (sum) eps (mean) wgt aidcvis msscvis tot_skn_cvis tot_phy_cvis tot_occ_cvis tot_spc_cvis ther_cvis tot_cvis, by(hipps);
sort hipps;
list, sep(0) clean noobs;
restore;

********************* This is used to create the LDS 60 day file used for repricing;
********************* !!!!!!!!!!!!!! CHANGE YEAR ON WAGE INDEX !!!!!!!!!!!!!!!!!!!!!!!!;


#delimit ;
keep abt_link bene_id clm_id clm_id_2nd provider from_dt thru_dt aidcvis msscvis tot_skn_cvis tot_phy_cvis tot_occ_cvis tot_spc_cvis 
     aidcmin msscmin tot_occ_cmin tot_phy_cmin tot_skn_cmin tot_spc_cmin first_vis lupa_add pep_ever outlier javahipps lupa wgt 
	 wage_index`yearshort' rural_cat rural_add_on outpay tot_pmt_noadj M0110_RECALC M1030_THH_ENT~R M1030_THH_IV_~S M1030_THH_NON~V 
	 M1030_THH_PAR~R M1200_VISION M1242_PAIN_FR~T M1306_UNHLD_S~R M1322_NBR_PRU~1 M1324_STG_PRB~U M1330 M1332 M1334 M1340 
	 M1342 M1400_WHEN_DY~C M1610_UR_INCONT M1620_BWL_INC~T M1630_OSTOMY M1810_CU_DRES~R M1820_CU_DRES~W M1830_CRNT_BA~G 
	 M1840_CUR_TOI~G M1850_CUR_TRN~G M1860_CRNT_AM~N M2030 M2200_THRPY_N~M M1021_PRI_DG~10 M1023_OTH~1_I10 M1023_OTH~2_I10 
	 M1023_OTH~3_I10 M1023_OTH~4_I10 M1023_OTH~5_I10 M1311_STG_2_P~M M1311_STG_3_P~M M1311_STG_4_P~M M1311_UNSTG_P~M 
	 M1311_UNSTG_C~M M1311_UNSTG_D~M M2001_DRUG_RG~D nrs_level nrs_wgt_fnl payday1 ASMTYPE;
	 
rename *, l;

rename abt_link abt_link;
rename bene_id bene_id ;
rename provider provider ;
rename from_dt from_dt ;
rename thru_dt thru_dt ;
rename wage_index`yearshort' wage_index`yearshort';
rename clm_id clm_id;
rename clm_id_2nd clm_id_2nd;
rename lupa lupa ;
rename javahipps hipps ;
rename wgt weight ;
rename pep_ever pep ;
rename outlier outlier ;
rename tot_pmt_noadj pmt_amt ;
rename outpay pmt_amt_out ;
rename tot_skn_cvis skn_cvis ;
rename tot_phy_cvis phy_cvis ;
rename tot_occ_cvis occ_cvis ;
rename tot_spc_cvis spc_cvis ;
rename aidcvis aid_cvis ;
rename msscvis mss_cvis ;
rename tot_skn_cmin skn_cmin ;
rename tot_phy_cmin phy_cmin ;
rename tot_occ_cmin occ_cmin ;
rename tot_spc_cmin spc_cmin ;
rename aidcmin aid_cmin ;
rename msscmin mss_cmin ;
rename first_vis first_vis;
rename lupa_add lupa_add;
rename rural_cat rural_cat;
rename rural_add_on rural_add_on;
rename m0110_recalc m0110_recalc;
rename m1810_cu_dress_upr m1810_cu_dress_upr ;
rename m1820_cu_dress_low m1820_cu_dress_low ;
rename m1830_crnt_bathg m1830_crnt_bathg ;
rename m1840_cur_toiltg m1840_cur_toiltg ;
rename m1850_cur_trnsfrng m1850_cur_trnsfrng ;
rename m1860_crnt_ambltn m1860_crnt_ambltn ;
rename m1021_pri_dgn_i10 m1021_pri_dgn_i10 ;
rename m1023_oth_dgn1_i10 m1023_oth_dgn1_i10 ;
rename m1023_oth_dgn2_i10 m1023_oth_dgn2_i10 ;
rename m1023_oth_dgn3_i10 m1023_oth_dgn3_i10 ;
rename m1023_oth_dgn4_i10 m1023_oth_dgn4_i10 ;
rename m1023_oth_dgn5_i10 m1023_oth_dgn5_i10 ;
rename m1030_thh_ent_nutr m1030_thh_ent_nutr ;
rename m1030_thh_iv_infus m1030_thh_iv_infus ;
rename m1030_thh_none_abv m1030_thh_none_abv ;
rename m1030_thh_par_nutr m1030_thh_par_nutr;
rename m1200_vision m1200_vision ;
rename m1242_pain_freq_actvty_mvmt m1242_pain_freq_actvty_mvmt ;
rename m1306_unhld_stg2_prsr_ulcr m1306_unhld_stg2_prsr_ulcr ;
rename m1311_stg_2_prsr_ulcrs_a1_num m1311_stg_2_prsr_ulcrs_a1_num ;
rename m1311_stg_3_prsr_ulcrs_b1_num m1311_stg_3_prsr_ulcrs_b1_num ;
rename m1311_stg_4_prsr_ulcrs_c1_num m1311_stg_4_prsr_ulcrs_c1_num ;
rename m1311_unstg_prsr_ulcr_d1_num  m1311_unstg_prsr_ulcr_d1_num ;
rename m1311_unstg_cvrg_e1_num       m1311_unstg_cvrg_e1_num ;
rename m1311_unstg_deep_tisue_f1_num m1311_unstg_deep_tisue_f1_num;
rename m1322_nbr_pru_stg1 m1322_nbr_pru_stg1 ;
rename m1324_stg_prbl_pru m1324_stg_prbl_pru ;
rename m1330 m1330 ;
rename m1332 m1332 ;
rename m1334 m1334 ;
rename m1340 m1340 ;
rename m1342 m1342 ;
rename m1400_when_dyspnic m1400_when_dyspnic ;
rename m1610_ur_incont m1610_ur_incont ;
rename m1620_bwl_incont m1620_bwl_incont ;
rename m1630_ostomy m1630_ostomy ;
rename m2001_drug_rgmn_rvw_cd m2001_drug_rgmn_rvw_cd ;
rename m2030 m2030 ;
rename m2200_thrpy_need_na_num m2200_thrpy_need_na_num;
rename nrs_level nrs_level;
rename nrs_wgt_fnl nrs_wgt_fnl;
rename payday1 payday1;


order abt_link bene_id  provider  from_dt  thru_dt  wage_index`yearshort' clm_id clm_id_2nd lupa  hipps  weight  pep  outlier  pmt_amt  pmt_amt_out  skn_cvis  phy_cvis  occ_cvis  spc_cvis  aid_cvis  mss_cvis  skn_cmin  phy_cmin  occ_cmin  spc_cmin  aid_cmin  mss_cmin  first_vis lupa_add rural_cat rural_add_on m0110_recalc m1810_cu_dress_upr  m1820_cu_dress_low  m1830_crnt_bathg  m1840_cur_toiltg  m1850_cur_trnsfrng  m1860_crnt_ambltn  m1021_pri_dgn_i10  m1023_oth_dgn1_i10  m1023_oth_dgn2_i10  m1023_oth_dgn3_i10  m1023_oth_dgn4_i10  m1023_oth_dgn5_i10  m1030_thh_ent_nutr  m1030_thh_iv_infus  m1030_thh_par_nutr  m1030_thh_none_abv  m1200_vision  m1242_pain_freq_actvty_mvmt  m1306_unhld_stg2_prsr_ulcr  m1311_stg_2_prsr_ulcrs_a1_num  m1311_stg_3_prsr_ulcrs_b1_num  m1311_stg_4_prsr_ulcrs_c1_num  m1311_unstg_cvrg_e1_num  m1311_unstg_deep_tisue_f1_num  m1311_unstg_prsr_ulcr_d1_num  m1322_nbr_pru_stg1  m1324_stg_prbl_pru  m1330  m1332  m1334  m1340 m1342 m1400_when_dyspnic m1610_ur_incont m1620_bwl_incont m1630_ostomy m2001_drug_rgmn_rvw_cd m2030 m2200_thrpy_need_na_num nrs_level nrs_wgt_fnl payday1 asmtype; 

label var abt_link "ABT: EPISODE UNIQUE IDENTIFIER";
label var bene_id "Beneficiary ID";
label var provider "CMS Certification Number (CCN)";
label var from_dt "Claim from date";
label var thru_dt "Claim thru date";
label var wage_index`yearshort' "Wage index that would be applied to the claim (20`yearshort')";
label var clm_id "Claim ID of the first 30-day period to make up this 60-day episode";
label var clm_id_2nd "Claim ID of the second 30-day period to make up this 60-day episode";
label var lupa "Flag for whether 60-day episode is a LUPA";
label var hipps "The HIPPS of the 60-day episode";
label var weight "153-group case-mix weight";
label var pep "Flag for whether the 60-day episode is a PEP";
label var outlier "Flag for whether the 60-day episode is an outlier ";
label var pmt_amt "Simulated 20`yearshort' 153-group payment amount (including outlier payments)";
label var pmt_amt_out "Simulated 20`yearshort' 153-group outlier payment";
label var skn_cvis "Nursing Visits";
label var phy_cvis "Physical Therapy Visits";
label var occ_cvis "Occupational Therapy Visits";
label var spc_cvis "Speech Language Pathology Visits";
label var aid_cvis "Aide Visits";
label var mss_cvis "Medical Social Services Visits";
label var skn_cmin "Nursing Minutes";
label var phy_cmin "Physical Therapy Minutes";
label var occ_cmin "Occupational Therapy Minutes";
label var spc_cmin "Speech Language Pathology Minutes";
label var aid_cmin "Aide Minutes";
label var mss_cmin "Medical Social Services Minutes";
label var first_vis "Indicator for whether first visit was SKN/PT/SLP (for LUPA add-on)";
label var lupa_add "Flag for LUPA add-on payment";
label var rural_cat "Rural Category for Rural Add-on Payment";
label var rural_add_on "Rural Add-on Percentage";
label var m0110_recalc "M0110: Episode Timing (Recalculated based on claims history) ";
label var m1810_cu_dress_upr "M1810: Current ability to dress upper body";
label var m1820_cu_dress_low "M1820: Current ability to dress lower body";
label var m1830_crnt_bathg "M1830: Bathing";
label var m1840_cur_toiltg "M1840: Toilet transferring";
label var m1850_cur_trnsfrng "M1850: Transferring";
label var m1860_crnt_ambltn "M1860: Ambulation/Locomotion";
label var m1021_pri_dgn_i10 "M1021: Primary diagnosis code ICD-10-CM";
label var m1023_oth_dgn1_i10 "M1023: Other diagnosis code 1 ICD-10-CM";
label var m1023_oth_dgn2_i10 "M1023: Other diagnosis code 2 ICD-10-CM";
label var m1023_oth_dgn3_i10 "M1023: Other diagnosis code 3 ICD-10-CM";
label var m1023_oth_dgn4_i10 "M1023: Other diagnosis code 4 ICD-10-CM";
label var m1023_oth_dgn5_i10 "M1023: Other diagnosis code 5 ICD-10-CM";
label var m1030_thh_ent_nutr "M1030: Therapies the patient receives at home (Enteral nutrition)";
label var m1030_thh_iv_infus "M1030: Therapies the patient receives at home (Intravenous or infusion therapies)";
label var m1030_thh_par_nutr "M1030: Therapies the patient receives at home (Parenteral nutrition)";
label var m1030_thh_none_abv "M1030: Therapies the patient receives at home (None of the above)";
label var m1200_vision "The patient's vision status";
label var m1242_pain_freq_actvty_mvmt "Frequency of pain interfering with patient's activity or movement";
label var m1306_unhld_stg2_prsr_ulcr "Flag if the patient has at least one unhealed pressure ulcer at stage II or higher";
label var m1311_stg_2_prsr_ulcrs_a1_num "The current number of unhealed pressure ulcers at stage II";
label var m1311_stg_3_prsr_ulcrs_b1_num "The current number of unhealed pressure ulcers at stage III";
label var m1311_stg_4_prsr_ulcrs_c1_num "The current number of unhealed pressure ulcers at stage IV";
label var m1311_unstg_cvrg_e1_num "The current number of unstageable unhealed pressure ulcers due to coverage of wound bed by slough and/or eschar";
label var m1311_unstg_deep_tisue_f1_num "The current number of unstageable unhealed pressure ulcers due to deep tissue injury in evolution";
label var m1311_unstg_prsr_ulcr_d1_num "The current number of unstageable unhealed pressure ulcers due to non-removable dressing/device";
label var m1322_nbr_pru_stg1 "The current number of stage I pressure ulcers";
label var m1324_stg_prbl_pru "The stage of the most problematic unhealed (observable) pressure ulcer";
label var m1330 "Flag for whether the patient has a stasis ulcer";
label var m1332 "The current number of (observable) stasis wounds";
label var m1334 "The status of the most problematic (observable) stasis ulcer";
label var m1340 "Flag for whether the patient has a surgical wound";
label var m1342 "The status of the most problematic (observable) surgical wound";
label var m1400_when_dyspnic "Flag for when the patient is dyspneic or noticeably short of breath";
label var m1610_ur_incont "Flag for whether the patient has urinary incontinence or urinary catheter presence";
label var m1620_bwl_incont "Frequency of bowel incontinence";
label var m1630_ostomy "Flag for whether the patient has an ostomy for bowel elimination that was related to an inpatient stay or necessitated a change in medical or treatment regimen";
label var m2001_drug_rgmn_rvw_cd "Flag for whether a complete drug regimen review was completed";
label var m2030 "Patient's current ability to prepare and take all prescribed injectable medications reliably and safely";
label var m2200_thrpy_need_na_num "Therapy Need: Recalculated based on actual number of therapy visits on claim";
label var nrs_level "NRS Level";
label var nrs_wgt_fnl "NRS Weight";
label var payday1 "Number of days used for PEP length";
label var asmtype "The reason the assessment is currently being completed";

**** clean up;
#delimit ;
replace weight = round(weight,.0001);
replace wage_index`yearshort' = round(wage_index`yearshort',.0001);
replace nrs_wgt_fnl = round(nrs_wgt_fnl,.0001);
replace first_vis = "" if lupa_add ~= 1;
replace lupa_add = 0 if lupa == 0;
format clm_id_2nd %12.0g;

recast double wage_index`yearshort' weight rural_add_on nrs_wgt_fnl;

replace wage_index`yearshort' = round(wage_index`yearshort',.0001);
replace weight = round(weight,.0001);
replace rural_add_on = round(rural_add_on,.0001);
replace nrs_wgt_fnl = round(nrs_wgt_fnl,.0001);
label var spc_cvis "Speech Language Pathology Visits";
label var spc_cmin "Speech Language Pathology Minutes";

compress;
mdesc;
desc;
sort bene_id clm_id;
save "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\LDS_60day(`date3')`date'_`date1'_`date2'.dta", replace;

preserve;
drop abt_link;
save "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\LDS_60day(CMS)(`date3')`date'_`date1'_`date2'.dta", replace;
datasig;
restore;


gen eps = 1;
gen rural = rural_add_on > 0 & rural_add_on ~= .;
gen hipps_short = substr(hipps,1,4);

******** Creates summary file by HIPPS;
preserve;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(hipps_short);
summ eps;
gen pcnt = eps/`r(sum)';

list *, sep(0) clean noobs;
export excel using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\Public Facing 60-Day(`date3')`date'_`date1'_`date2'.xlsx", firstrow(variables) replace;
datasig;
restore;


#delimit ;
******** Creates summary file by HIPPS categories ;
gen     ther = "";
replace ther = "1) Early         -  0 - 13 Therapy visits" if substr(hipps_short,1,1) == "1";
replace ther = "2) Early         - 14 - 19 Therapy visits" if substr(hipps_short,1,1) == "2";
replace ther = "3) Late          -  0 - 13 Therapy visits" if substr(hipps_short,1,1) == "3";
replace ther = "4) Late          - 14 - 19 Therapy visits" if substr(hipps_short,1,1) == "4";
replace ther = "5) Early or Late -     20+ Therapy visits" if substr(hipps_short,1,1) == "5";

gen     clin = "";
replace clin = "1) Low"  if substr(hipps_short,2,1) == "A"; 
replace clin = "2) Med"  if substr(hipps_short,2,1) == "B";
replace clin = "3) High" if substr(hipps_short,2,1) == "C";

gen     func = "";
replace func = "1) Low"  if substr(hipps_short,3,1) == "F"; 
replace func = "2) Med"  if substr(hipps_short,3,1) == "G";
replace func = "3)High" if substr(hipps_short,3,1) == "H";
mdesc ther clin func;

preserve;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(ther);
summ eps;
gen pcnt = eps/`r(sum)';
gen clin = "All";
gen func = "All";
tempfile temp_ther;
save   "`temp_ther'";
restore;

preserve;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(clin);
summ eps;
gen pcnt = eps/`r(sum)';
gen ther = "All";
gen func = "All";
tempfile temp_clin;
save   "`temp_clin'";
restore;

preserve;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(func);
summ eps;
gen pcnt = eps/`r(sum)';
gen ther = "All";
gen clin = "All";
tempfile temp_func;
save   "`temp_func'";
restore;

preserve;
replace ther = "All";
replace clin = "All";
replace func = "All";
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(ther clin func);
summ eps;
gen pcnt = eps/`r(sum)';

append using "`temp_ther'";
append using "`temp_clin'";
append using "`temp_func'";
order ther clin func eps pcnt rural pmt_amt pmt_amt_out outlier pep lupa weight phy_cvis occ_cvis spc_cvis skn_cvis mss_cvis aid_cvis phy_cmin occ_cmin spc_cmin skn_cmin mss_cmin aid_cmin ;

list *, sep(0) clean noobs;

export excel using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\Public Facing 60-Day - Summary (`date3')`date'_`date1'_`date2'.xlsx", firstrow(variables) replace;
datasig;
restore;



******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
******************** Some comparison info about actual 60-day periods that start in 2019 and end in 2020;
/*;
preserve;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf19_FINAL_2019\1 PRE GROUPER\hhf19_150_epioas_exclude.dta", clear;
rename *, l;
keep if year(thru_dt) == 2020;

gen hipps_short = substr(hipps_fnl,1,4);
tab hipps_short, sort;
tab hipps_short;

gen hipps1 = substr(hipps_fnl,1,1);
gen hipps2 = substr(hipps_fnl,2,1);
gen hipps3 = substr(hipps_fnl,3,1);
gen hipps4 = substr(hipps_fnl,4,1);
gen hipps5 = substr(hipps_fnl,5,1);

tab hipps1;
tab hipps2;
tab hipps3;
tab hipps4;
tab hipps5;

tab lupa;
tab pep;
tab outlier;
summ cwgt153_fnl if lupa == 0 & pep == 0;

egen tot_cvis = rowtotal(aidcvis msscvis  tot_skn_cvis  tot_phy_cvis tot_occ_cvis tot_spc_cvis);
egen ther_cvis1 = rowtotal(tot_phy_cvis tot_occ_cvis tot_spc_cvis);
summ tot_cvis;
summ ther_cvis;
summ ther_cvis1;
summ aidcvis msscvis  tot_skn_cvis  tot_phy_cvis tot_occ_cvis tot_spc_cvis;

merge 1:1 abt_link using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf19_FINAL_2019\2 PESKIES\hhf19_245_cap_min_30day.dta";
keep if _merge == 3;
drop    _merge;
summ aidcmin msscmin tot_skn_cmin tot_phy_cmin tot_occ_cmin tot_spc_cmin;
summ aidcmin msscmin tot_skn_cmin tot_phy_cmin tot_occ_cmin tot_spc_cmin if outlier == 1 | outl_cap == 1;

summ aidcmin_cap msscmin_cap tot_skn_cmin_cap tot_phy_cmin_cap tot_occ_cmin_cap tot_spc_cmin_cap;
summ aidcmin_cap msscmin_cap tot_skn_cmin_cap tot_phy_cmin_cap tot_occ_cmin_cap tot_spc_cmin_cap if outlier == 1 | outl_cap == 1;

gen     vis_group = "";
replace vis_group = "1)  0-4"   if tot_cvis >= 0  & tot_cvis <=  4;
replace vis_group = "2)  5-13"  if tot_cvis >= 5  & tot_cvis <= 13;
replace vis_group = "3)  14-19" if tot_cvis >= 14 & tot_cvis <= 19;
replace vis_group = "4)  20-29" if tot_cvis >= 20 & tot_cvis <= 29;
replace vis_group = "5)  30+"   if tot_cvis >= 30 & tot_cvis ~=  .;
tab     vis_group;

gen any_therapy = ther_cvis >= 1 & ther_cvis ~= .;
tab any_therapy;

summ val_amt_17, detail;
display "Total: `r(sum)'";
summ pmt_amt if lupa    == 1;
display "Total: `r(sum)'";
summ pmt_amt if pep     == 1 & outlier == 0;
display "Total: `r(sum)'";
summ pmt_amt if pep     == 1 & outlier == 1;
display "Total: `r(sum)'";
summ pmt_amt if pep     == 0 & outlier == 1;
display "Total: `r(sum)'";
summ pmt_amt if outlier == 0 & lupa == 0 & pep == 0;
display "Total: `r(sum)'";

display "This is what Mollie requested - HIPPS with info on visits - drops LUPAs - actual 60-day episodes";
drop if lupa == 1;
gen eps = 1;
collapse (sum) eps (mean) cwgt153_fnl aidcvis msscvis tot_skn_cvis tot_phy_cvis tot_occ_cvis tot_spc_cvis ther_cvis tot_cvis, by(hipps_short);
sort hipps;
list, sep(0) clean noobs;

restore;
*/;

/*;
#delimit ;
********** This is the actual 2018 data - I'm going to use it to make that HIPPS table again;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf18_FINAL_2018\1 PRE GROUPER\hhf18_150_epioas_exclude", replace;
gen hipps_short = substr(hipps_fnl,1,4);
drop if lupa == 1;
gen eps = 1;
collapse (sum) eps (mean) cwgt153_fnl aidcvis msscvis tot_skn_cvis tot_phy_cvis tot_occ_cvis tot_spc_cvis ther_cvis tot_cvis, by(hipps_short);
sort hipps;
list, sep(0) clean noobs;
*/;

*********  Program ends;
datasig;
display "Start: `starttime'";
display "End: " "$S_TIME";
log close;	

